/* This file has been generated by ox-ui-module generator.
 * Please only apply minor changes (better no changes at all) to this file
 * if you want to be able to run the generator again without much trouble.
 *
 * If you really have to change this file for whatever reason, try to contact
 * the core team and describe your use-case. May be, your changes can be
 * integrated into the templates to be of use for everybody.
 */
'use strict';

module.exports = function (grunt) {

    grunt.isPeerDependencyInstalled = function (name) {
        var path = require('path');
        var root = path.resolve('node_modules');
        return grunt.file.exists(path.join(root, name, 'package.json'));
    };
    if (!grunt.isPeerDependencyInstalled('grunt-check-dependencies')) {
        grunt.fail.fatal('Essential dependencies missing, try to run `npm install` or at least `npm install --production`');
    }

    var path = require('path');

    // make grunt config extendable
    grunt.config.extend = function (k, v) {
        grunt.config(k, Object.assign({}, grunt.config(k), v));
    };

    grunt.config('pkg', grunt.file.readJSON('package.json'));

    grunt.config('local', Object.assign(
        grunt.file.readJSON(path.join(path.dirname(__filename), 'local.conf.default.json')),
        grunt.file.exists('grunt/local.conf.json') ? grunt.file.readJSON('grunt/local.conf.json') : {}
    ));
    //make coreDir sure coreDir exists and is a relative path,
    //because absolute paths will break less and karma setups
    //for less, in detail, this will break @import statements
    //(see http://stackoverflow.com/questions/10715214/lessc-with-an-absolute-path-in-importing)
    var coreDir = grunt.option('coreDir') || grunt.config('local.coreDir') || 'build/';
    //expand ~/ like many posix shells do (see http://stackoverflow.com/questions/6145492/how-to-resolve-a-relative-path-in-node)
    coreDir = coreDir.replace(/^~\//, (process.env.HOME || '~') + '/');
    if (coreDir.indexOf('~/') === 0) {
        grunt.log.warn('coreDir starts with ~/ and could not be expanded using $HOME environment variable.');
    }
    grunt.config('local.coreDir', path.relative(process.cwd(), coreDir));
    grunt.verbose.ok('Using coreDir:', grunt.config('local.coreDir'));

    grunt.util.runPrefixedSubtasksFor = function (main_task, prefix) {
        return function () {
            var list = [];

            //remove 'newer:', because this doesn't belong to the configuration
            //TODO: may be find a more general way, like a custom 'prefix' parameter
            //      to prefix the main_task
            for (var key in grunt.config(main_task.replace('newer:', ''))) {
                if (key.substr(0, prefix.length) === prefix) {
                    list.push(key);
                }
            }
            list = list.map(function (name) {
                return main_task + ':' + name;
            });

            grunt.task.run(list);
        };
    };

    grunt.util.registerDummyTask = function (name, deps) {
        deps = [].concat(deps);

        grunt.registerTask(name, 'Dummy task to inform about missing optional dependency' + deps.join(', '), function () {
            grunt.log.warn('Missing optional dependency', deps.join(', '));
            grunt.log.warn('Run `npm install --save-dev ' + deps.join(' ') + '` to permanently add this to your projects.');
        });
    };

    // custom tasks
    grunt.registerTask('manifests', ['concat:manifests']);
    grunt.registerTask('lint', ['newer:eslint:all']);

    // force cache-busting
    grunt.registerTask('force_update', function () {
        var fs = require('fs'),
            dir = grunt.config('local.appserver.prefixes.0') || 'build/';
        fs.utimesSync(dir, new Date(), new Date());
    });
    // steps to build the ui (ready for development)
    grunt.registerTask('build', ['lint', 'copy_build', 'newer:concat', 'newer:less', 'compile_po']);
    // run development setup
    grunt.registerTask('dev', ['default', 'connect', 'test', 'watch']);
    // run a clean development setup
    grunt.registerTask('cleanDev', ['clean', 'default', 'connect', 'test', 'watch']);
    // default task
    grunt.registerTask('default', ['checkDependencies:dev', 'build']);
    // refresh the browser if watch task (with livereload) is running
    grunt.registerTask('refresh', 'force an update and reload the broweser', ['force_update', 'send_livereload']);

    // load pre-configured grunt tasks
    grunt.loadTasks(path.join(path.dirname(__filename), 'shared'));

    // deprecated bower task
    grunt.registerTask('bower:install', function () {
        grunt.log.error('The use of bower is deprecated in 7.10, please use npm.');
    });

    try {
        require(path.relative(__dirname, 'grunt/local.conf.js'))(grunt);
    } catch (e) {
        if (e.code !== 'MODULE_NOT_FOUND') {
            // module not found is okay, but everything else is worth a warning
            grunt.fail.warn('Error processing grunt/local.conf.js: "' + e + '"');
        }
    }
};
