/**
 * This work is provided under the terms of the CREATIVE COMMONS PUBLIC
 * LICENSE. This work is protected by copyright and/or other applicable
 * law. Any use of the work other than as authorized under this license
 * or copyright law is prohibited.
 *
 * http://creativecommons.org/licenses/by-nc-sa/2.5/
 * © 2017 OX Software GmbH, Germany. info@open-xchange.com
 *
 * @author Greg Hill <greg.hill@open-xchange.com>
 */

describe('Settings', function () {

    describe('Setup and Tour', function () {

        it('Initial Setup', function (client) {
            // First, wipe the 2rd test user's Guard account
            client.wipeUser(1);

            // Login to settings
            client
            .login(['app=io.ox/settings', 'folder=virtual/settings/oxguard'], { userIndex: 1 })
            .waitForElementVisible('.io-ox-guard-settings', 5000)
            .waitForElementVisible('.guard-start-button', 1000);

            // Click Start button and verify wizard opens with
            client
            .click('.guard-start-button')
            .waitForElementVisible('.btn.btn-primary[data-action="next"]', 1000)
            .assert.containsText('.btn.btn-primary[data-action="next"]', 'Start Setup');

            // Verify wizard opens
            client
            .click('.btn.btn-primary[data-action="next"]')
            .waitForElementVisible('.wizard-content .guard-create-key', 1000)
            .assert.containsText('.wizard-content .guard-create-key', 'Please enter a password');

            // Try mismatched password and verify error
            client
            .insertPassword('#newogpassword', 1)
            .setValue('#newogpassword2', 'mismatch')
            .pause(10)
            .assert.containsText('.password-validation .error-msg', 'Passwords not equal')
            .assert.attributeEquals('.btn.btn-primary[data-action="next"]', 'disabled', 'true');

            // Correct password and verify error gone
            client
            .insertPassword('#newogpassword2', 1)
            .pause(1000)
            .getAttribute('.btn.btn-primary[data-action="next"]', 'disabled', function (result) {
                this.assert.equal(result.value, null);  //verify button no longer disabled
            })
            .setValue('input[name="recoverymail"]', 'test@email.com')
            .pause(10)
            .click('.btn.btn-primary[data-action="next"]');

            // Verify complete shown, and start tour
            client
            .waitForElementVisible('.btn.btn-primary[data-action="done"]', 1000)
            .assert.containsText('#startTourLink', 'Guided tour')
            .click('#startTourLink');

        });

        it('Initial Tour', function (client) {

            // Make sure tour is set for non-advanced
            client
            .setSetting('oxguard', 'advanced', false);

            // Verify compose opens and wizard shown
            client
            .waitForElementVisible('.io-ox-mail-compose textarea.plain-text,.io-ox-mail-compose .contenteditable-editor', 10000)
            .waitForElementVisible('.hotspot', 2000)
            .assert.containsText('.wizard-content', 'Security and privacy')
            .assert.elementPresent('.btn.btn-primary[data-action="next"]')
            .click('.btn.btn-primary[data-action="next"]');

            // Verify Security Settings opened, and password management illustrated
            client
            .waitForElementVisible('.io-ox-guard-settings', 3000)
            .waitForElementVisible('.wizard-content', 500)
            .assert.containsText('.wizard-content', 'You already set up')
            .assert.elementPresent('.wizard-overlay.wizard-spotlight.abs')  // Highlighted area
            .assert.elementPresent('.btn.btn-primary[data-action="next"]')
            .click('.btn.btn-primary[data-action="next"]');

            // Begin illustrating Defaults
            client
            .waitForElementVisible('.hotspot', 500)
            .assert.elementPresent('.wizard-overlay.wizard-spotlight.abs')
            .assert.elementPresent('.wizard-content')
            .assert.containsText('.wizard-content', 'From here')
            .assert.elementPresent('.btn.btn-primary[data-action="next"]')
            .click('.btn.btn-primary[data-action="next"]');

            // Default signing
            client
            .waitForElementVisible('.hotspot', 500)
            .assert.elementPresent('.wizard-content')
            .assert.containsText('.wizard-title', 'Signature')
            .assert.elementPresent('.btn.btn-primary[data-action="next"]')
            .click('.btn.btn-primary[data-action="next"]');

            // Optional advanced user options
            client
            .waitForElementVisible('.hotspot', 500)
            .assert.elementPresent('.wizard-content')
            .assert.containsText('.wizard-title', 'Advanced User Settings')
            .assert.elementPresent('.btn.btn-primary[data-action="next"]')
            .click('.btn.btn-primary[data-action="next"]');

            // Opens up compose again to show unlock
            client
            .waitForElementVisible('.io-ox-mail-compose textarea.plain-text,.io-ox-mail-compose .contenteditable-editor', 10000)
            .waitForElementVisible('.hotspot', 2000)
            .assert.containsText('.wizard-title', 'Enabling and disabling')
            .assert.elementPresent('.btn.btn-primary[data-action="next"]')
            .click('.btn.btn-primary[data-action="next"]');

            // Show file encryption
            client
            .waitForElementVisible('.io-ox-files-main .window-sidepanel', 3000)
            .waitForElementVisible('.wizard-title', 500)
            .assert.containsText('.wizard-title', 'Encrypt file')
            .assert.elementPresent('.btn.btn-primary[data-action="next"]')
            .click('.btn.btn-primary[data-action="next"]');

            // Show option to restart tour
            client
            .waitForElementVisible('li.og_tour', 500)
            .waitForElementVisible('.hotspot', 500)
            .assert.containsText('.wizard-title', 'Restart')
            .assert.elementPresent('.btn.btn-primary[data-action="next"]')
            .click('.btn.btn-primary[data-action="next"]');

            // Show done
            client
            .waitForElementVisible('.btn.btn-primary[data-action="done"]', 1000)
            .assert.containsText('.wizard-title', 'completed')
            .click('.btn.btn-primary[data-action="done"]');

            client
            .logout();
        });
    })
});