/**
 * This work is provided under the terms of the CREATIVE COMMONS PUBLIC
 * LICENSE. This work is protected by copyright and/or other applicable
 * law. Any use of the work other than as authorized under this license
 * or copyright law is prohibited.
 *
 * http://creativecommons.org/licenses/by-nc-sa/2.5/
 * © 2017 OX Software GmbH, Germany. info@open-xchange.com
 *
 * @author Greg Hill <greg.hill@open-xchange.com>
 */

describe('Mail', function () {

    describe('Send To Self with attachment', function () {

        it('Compose secure email', function (client) {

            client
            .login('app=io.ox/mail')
            .waitForElementVisible('.io-ox-mail-window .window-body .classic-toolbar a[data-action="compose"]', 20000);

            client.verifyUserSetup();

            // 1) Login to mail app
            client
                .clickWhenVisible('.launchers li[data-app-name="io.ox/mail"]')
                .assert.containsText('*[data-app-name="io.ox/mail"]', 'Mail');

            // 2) Mark all messages as read to identify the new message later on
            client
                .selectFolder({ id: 'default0/INBOX' })
                .openFolderContextMenu({ id: 'default0/INBOX' })
                .clickWhenVisible('.dropdown.open a[data-action="markfolderread"]');

            // 3) Open mail compose
            client.waitForElementVisible('.io-ox-mail-window .window-body .classic-toolbar a[data-action="compose"]', 20000)
                .assert.containsText('.io-ox-mail-window .window-body .classic-toolbar a[data-action="compose"]', 'Compose')
                .clickWhenEventListener('.io-ox-mail-window .window-body  .classic-toolbar a[data-action="compose"]', 'click', 2500)
                .waitForElementVisible('.io-ox-mail-compose textarea.plain-text,.io-ox-mail-compose .contenteditable-editor', 20000)
                .pause(1000)
                .assert.title('App Suite. Compose');

            // 4) Select "Encrypt" as text format under "Options"
            client
                .clickWhenVisible('.io-ox-mail-compose div[data-extension-id="composetoolbar-menu"] .dropdown.security-options', 2000)
                .clickWhenVisible('.dropdown.open a[data-name="encrypt"]', 2000)
                .waitForElementVisible('.fa.fa-2x.encrypted', 20000);

            // 5) Set a recipient, add a subject and mail text
            client
                .insertMailaddress('.io-ox-mail-compose div[data-extension-id="to"] input.tt-input', 0)
                .setValue('.io-ox-mail-compose div[data-extension-id="subject"] input', 'Test subject')
                .setValue('.io-ox-mail-compose-window .editor .editable', 'Test text');

            // 6) Check that the key lock icon appears with the user token
            client
                 .waitForElementVisible('i.fa.fa-key.oxguard_token.key_tooltip.trusted_key', 2000);
        });

        it('Add secure attachment', function (client) {

            client
            .addAttachment('.io-ox-mail-compose input[type="file"]');

            // Send
            client
                .click('.io-ox-mail-compose-window .window-footer button[data-action="send"]');

        });

        it('Verify able to open attachment', function (client) {
            // Wait for message
            client
                .waitForElementVisible('.io-ox-mail-window .leftside', 2000)
                .click('#io-ox-refresh-icon')
                .waitForElementVisible('.io-ox-mail-window .leftside ul li.unread', 20000)
                .click('.io-ox-mail-window .leftside ul li.unread')
                .waitForElementVisible('.io-ox-mail-window .mail-detail-pane .subject', 1000)
                .assert.containsText('.io-ox-mail-window .mail-detail-pane .subject', 'Test subject');

            // Decrypt message
            client
                .waitForElementVisible('.btn.oxguard_passbutton', 2000)
                .waitForElementVisible('input.form-control.password_prompt', 2000)
                .insertPassword('input.form-control.password_prompt', 0)
                .click('.btn.oxguard_passbutton');

            // Verify decrypted
            client
                .shadowWaitForElementVisible('.io-ox-mail-window .mail-detail-pane .body::shadow .mail-detail-content', 2500)
                .assert.shadowContainsText('.io-ox-mail-window .mail-detail-pane .body::shadow .mail-detail-content', 'Test text');

            // Verify has attachment view option and open
            client
                .waitForElementVisible('a[data-ref="io.ox/mail/actions/view-attachment"]', 500)
                .click('a[data-ref="io.ox/mail/actions/view-attachment"]');

            // Verify password prompt
            client
                .waitForElementVisible('#ogPassword', 500)
                .insertPassword('#ogPassword')
                .click('.btn-primary[data-action="ok"]');

            // Verify image displayed
            client
                .waitForElementVisible('.swiper-slide-active .viewer-displayer-item.viewer-displayer-image', 2000);

            // Close and return
            client
                .click('a.viewer-toolbar-close')
                .waitForElementVisible('.io-ox-action-link[data-action="compose"]', 1000);

            client
                .logout();

        });
    });
});