/**
 * This work is provided under the terms of the CREATIVE COMMONS PUBLIC
 * LICENSE. This work is protected by copyright and/or other applicable
 * law. Any use of the work other than as authorized under this license
 * or copyright law is prohibited.
 *
 * http://creativecommons.org/licenses/by-nc-sa/2.5/
 * © 2017 OX Software GmbH, Germany. info@open-xchange.com
 *
 * @author Greg Hill <greg.hill@open-xchange.com>
 */

describe('Mail', function () {

    describe('Send as new user', function () {

        it('Compose secure email', function (client) {

            // First, let's log in as testuser1 and make sure set up
            client
                .login('app=io.ox/mail')
                .waitForElementVisible('.io-ox-mail-window .window-body .classic-toolbar a[data-action="compose"]', 20000);

            client.verifyUserSetup();

            // Login to mail app
            client
                .clickWhenVisible('.launchers li[data-app-name="io.ox/mail"]')
                .assert.containsText('*[data-app-name="io.ox/mail"]', 'Mail');

            // Mark all messages as read to identify the new message later on
            client
                .selectFolder({id: 'default0/INBOX'})
                .openFolderContextMenu({id: 'default0/INBOX'})
                .clickWhenVisible('.dropdown.open a[data-action="markfolderread"]');

            // OK First user is set up and ready
            client.logout(false);

            // Wipe user testuser2
            client.wipeUser(1);

            // Login as user 2
            client
                .login('app=io.ox/mail', {'userIndex': 1})
                .waitForElementVisible('.io-ox-mail-window .window-body .classic-toolbar a[data-action="compose"]', 20000);

            //Open mail compose
            client.waitForElementVisible('.io-ox-mail-window .window-body .classic-toolbar a[data-action="compose"]', 20000)
                .clickWhenEventListener('.io-ox-mail-window .window-body  .classic-toolbar a[data-action="compose"]', 'click', 2500)
                .waitForElementVisible('.io-ox-mail-compose textarea.plain-text,.io-ox-mail-compose .contenteditable-editor', 20000)
                .pause(1000)
                .assert.title('App Suite. Compose');

            // Set a recipient, add a subject and mail text
            client
                .insertMailaddress('.io-ox-mail-compose div[data-extension-id="to"] input.tt-input', 0)
                .setValue('.io-ox-mail-compose div[data-extension-id="subject"] input', 'Test subject')
                .setValue('.io-ox-mail-compose-window .editor .editable', 'Test text');
        });

        it('Setup shown when selecting encrypt', function (client) {

            // Select "Encrypt" as text format under "Options"
            client
                .clickWhenVisible('.io-ox-mail-compose div[data-extension-id="composetoolbar-menu"] .dropdown.security-options', 2000)
                .clickWhenVisible('.dropdown.open a[data-name="encrypt"]', 2000)
                .waitForElementVisible('.fa.fa-2x.encrypted', 2000);

            // Setup should display
            client
                .waitForElementVisible('.wizard-footer .btn-primary[data-action="next"]', 1000)
                .click('.wizard-footer .btn-primary[data-action="next"]')
                .waitForElementVisible('#newogpassword', 500);

            // Input new passwords
            client
                .insertPassword('#newogpassword', 1)
                .pause(10)
                .insertPassword('#newogpassword2', 1)
                .pause(10)
                .click('.btn-primary[data-action="next"]')
                .waitForElementVisible('.wizard-footer .btn-primary[data-action="done"]', 1000)
                .assert.containsText('.wizard-header', 'completed');

            client
                .click('.btn-primary[data-action="done"]')
                .waitForElementNotPresent('.wizard-container', 1000);

            //  Should be done setup.  Continue

            // Check that the key lock icon appears with the user token
            client
                .waitForElementVisible('i.fa.fa-key.oxguard_token.key_tooltip.trusted_key', 2000);

            // Send the E-Mail and check it as recipient
            client
                .click('.io-ox-mail-compose-window .window-footer button[data-action="send"]')
                .waitForElementVisible('.io-ox-mail-window .leftside', 2000);

            client.logout(false);
        });

        it('Recipient email readable', function (client) {

            client
                .login('app=io.ox/mail')
                .waitForElementVisible('.io-ox-mail-window .leftside ul li.unread', 20000)
                .click('.io-ox-mail-window .leftside ul li.unread');

            client
                .waitForElementVisible('.io-ox-mail-window .mail-detail-pane .subject', 1000)
                .assert.containsText('.io-ox-mail-window .mail-detail-pane .subject', 'Test subject');

            // Decrypt
            client
                .waitForElementVisible('.btn.oxguard_passbutton', 2000)
                .waitForElementVisible('input.form-control.password_prompt', 2000)
                .insertPassword('input.form-control.password_prompt', 0)
                .click('.btn.oxguard_passbutton');

            // Verify decrypted
            client
                .shadowWaitForElementVisible('.io-ox-mail-window .mail-detail-pane .body::shadow .mail-detail-content', 2500)
                .assert.shadowContainsText('.io-ox-mail-window .mail-detail-pane .body::shadow .mail-detail-content', 'Test text');

            client.logout();
        });

    });

});