/**
 * This work is provided under the terms of the CREATIVE COMMONS PUBLIC
 * LICENSE. This work is protected by copyright and/or other applicable
 * law. Any use of the work other than as authorized under this license
 * or copyright law is prohibited.
 *
 * http://creativecommons.org/licenses/by-nc-sa/2.5/
 * © 2017 OX Software GmbH, Germany. info@open-xchange.com
 *
 * @author Greg Hill <greg.hill@open-xchange.com>
 */

describe('Drive', function () {

    describe('Create text file then encrypt', function () {

        it('Create text file', function (client) {
            client
            .login('app=io.ox/files')
            .waitForElementVisible('.io-ox-files-window .window-body .classic-toolbar a[data-action="create"]', 20000);

            // Make sure user set up
            client
            .verifyUserSetup();

            // Delete test file if already present
            client
            .deleteFile('testDoc.txt')
            .deleteFile('testDoc.txt.pgp');

            // Click to open note
            client
            .click('.io-ox-files-window .window-body .classic-toolbar a[data-action="create"]')
            .clickWhenVisible('a[data-action="io.ox/files/actions/editor-new"]');

            // Populate note and save
            client
            .waitForElementVisible('.io-ox-editor textarea', 1000, 'Editor not visible')
            .setValue('.io-ox-editor textarea', 'This is a test document')
            .setValue('input.title', 'testDoc')
            .click('.save.btn-primary')
            .pause(300)
            .click('.quit.btn');

        });

        it('Encrypt File and verify decryption', function (client) {

            // Select the file
            client
            .selectFile('testDoc.txt');

            // Encrypt it
            client
            .clickWhenVisible('.io-ox-action-link[data-action="more"]')
            .clickWhenVisible('.io-ox-action-link[data-action="encrypt"]')
            .pause(10)
            .waitForElementVisible('.fa.fa-refresh.fa-spin-paused', 2000);

            //Open to decrypt
            client
            .selectFile('testDoc.txt.pgp', true)
            .waitForElementVisible('input.password_prompt[name="ogPassword"]', 1000);

            // Insert password
            client
            .insertPassword('input.password_prompt[name="ogPassword"]')
            .click('.btn-primary[data-action="ok"]');

            // Verify decrypted
            client
            .waitForElementVisible('.swiper-slide-active .white-page.letter.plain-text', 5000)
            .assert.containsText('.swiper-slide-active .white-page.letter.plain-text', 'This is a test document');

            // Close and return
            client
            .click('a.viewer-toolbar-close[data-action="close"]')
            .waitForElementVisible('.io-ox-action-link[data-action="create"]', 1000);

        });

        it('Test remove encryption', function (client) {

            // Select the file
            client
            .selectFile('testDoc.txt.pgp');

            client
            .clickWhenVisible('.io-ox-action-link[data-action="more"]')
            .clickWhenVisible('.io-ox-action-link[data-action="remencrypt"]')
            .waitForElementVisible('input.password_prompt[name="ogPassword"]', 1000);

            // Insert password and decrypt
            client
            .insertPassword('input.password_prompt[name="ogPassword"]')
            .click('.btn-primary[data-action="ok"]')
            .pause(10)
            .waitForElementVisible('.fa.fa-refresh.fa-spin-paused', 2000);

            // File sync
            client
            .pause(2000);

            //Verify file there and decrypted
            client
            .selectFile('testDoc.txt');

            // Cleanup
            client
            .deleteFile('testDoc.txt');

            client
            .logout();
        });

    });
});
