/**
 * This work is provided under the terms of the CREATIVE COMMONS PUBLIC
 * LICENSE. This work is protected by copyright and/or other applicable
 * law. Any use of the work other than as authorized under this license
 * or copyright law is prohibited.
 *
 * http://creativecommons.org/licenses/by-nc-sa/2.5/
 * © 2017 OX Software GmbH, Germany. info@open-xchange.com
 *
 * @author Greg Hill <greg.hill@open-xchange.com>
 */

/**
 * Verifies a user has been set up and has Guard keys.
 * Should be called AFTER login completed
 * Changes the URL.  Will need redirect after calling (such as using the login command)
 */
exports.command = function (userIndex) {

    if (!userIndex) userIndex = 0;
    var users = this.globals.users;
    if (!users || !users.length) this.assert.fail('user not found', 'A configured user', 'Expected at least one configured user in the global array "users".');
    if (users.length < userIndex) this.assert.fail('user not found', 'A user at index ' + userIndex, 'Expected a configured user in the globals "users" array at position ' + userIndex + '.');
    var user = users[userIndex];
    if (!user.password) this.assert.fail('user password not defined', 'A user at index ' + userIndex, 'Expected a configured password in the globals "users" array at position ' + userIndex + '.')
    this
    .timeoutsAsyncScript(2000)
    .executeAsync(function (user, done) {
        if (window.oxguarddata.passcode === null) {  // already setup
            done(true);
            return;
        }
        if (window.oxguarddata.passcode === 'No Key') { // Needs setup
            require (['oxguard/core/og_http'], function (og_http) {
                var json = {
                        name: user.username,
                        password: user.password
                    };
                og_http.simplePost(ox.apiRoot + '/oxguard/keys?action=create', '', json)
                .done(function (data) {
                    if (data.error) done(data.error_desc);
                    if (data.data) {
                        window.oxguarddata.passcode = null;
                        done(true);
                    } else {
                        done('Failed to get login data');
                    }
                })
                .fail(function (e) {
                    done('fail post');
                });
            });
        } else {
            done(fail);  // temporary password or lockout
        }
    }, [user], function (result) {
        console.log(result);
        this.assert.equal(result.value, true, "User setup");
    });

return this;

};