/**
 * This work is provided under the terms of the CREATIVE COMMONS PUBLIC
 * LICENSE. This work is protected by copyright and/or other applicable
 * law. Any use of the work other than as authorized under this license
 * or copyright law is prohibited.
 *
 * http://creativecommons.org/licenses/by-nc-sa/2.5/
 * © 2017 OX Software GmbH, Germany. info@open-xchange.com
 *
 * @author Greg Hill <greg.hill@open-xchange.com>
 */

/**
 * This verifies the user is configured for Guard
 */
exports.command = function () {

    this
    .timeoutsAsyncScript(2000)
    .executeAsync(function (data, done) {
        var browser = this;
        require(['settings!oxguard'], function (settings) {
            if (!window.oxguarddata || ! window.oxguarddata.settings || !window.oxguarddata.settings.oxguard) { // First, check backend response
                done('oxguarddata.settings.guard not true');
            } else {
                if (settings.get('cryptoProvider') === 'guard') { // Make sure not mailvelope configured
                    done('ok');
                } else {
                    done('cryptoprovider configured as ' + settings.get('cryptoProvider'));
                }
            }
        }, function () {
            done('problem loading settings');
        });
    }, [''], function (result) {
        console.log(result);
        this.assert.equal(result.value, 'ok', "Guard enabled");
    });

return this;

};