/**
 * This work is provided under the terms of the CREATIVE COMMONS PUBLIC
 * LICENSE. This work is protected by copyright and/or other applicable
 * law. Any use of the work other than as authorized under this license
 * or copyright law is prohibited.
 *
 * http://creativecommons.org/licenses/by-nc-sa/2.5/
 * © 2017 OX Software GmbH, Germany. info@open-xchange.com
 *
 * @author Greg Hill <greg.hill@open-xchange.com>
 */

/**
 * Adds an attachment to an input[type="file"]
 * @param selector {string} the selector of an editable field
 * @param userIndex {number} the users position in the global users array
 */
exports.command = function (selector, type, index) {

    if (!index) index = 0;
    if (!type) type = 'image';
    var path = '';
    switch (type) {
        case 'image':
            var images = this.globals.images;
            if (index > images.length) this.assert.fail('image not found', 'No image found at index ' + index);
            path = images[index];
            break;
        case 'doc':
            var docs = this.globals.docs;
            if (index > docs.length) this.assert.fail('document not found', 'No Document found at index ' + index);
            path = docs[index];
            break;
    }
    this.setValue(selector, require("path").resolve(__dirname, '../', path));

    return this;

};