/**
 * This work is provided under the terms of the CREATIVE COMMONS PUBLIC
 * LICENSE. This work is protected by copyright and/or other applicable
 * law. Any use of the work other than as authorized under this license
 * or copyright law is prohibited.
 *
 * http://creativecommons.org/licenses/by-nc-sa/2.5/
 * © 2017 OX Software GmbH, Germany. info@open-xchange.com
 *
 * @author Greg Hill <greg.hill@open-xchange.com>
 */

/// <reference path="../../steps.d.ts" />

Feature('Settings - Password Management');

Before(async function (users) {
    await users.create();
});

After(async function (users) {
    await users.removeAll();
});

Scenario('Reset Password and Change', async function (I, users) {

    const o = {
        user: users[0]
    };
    const userdata = o.user.userdata;

    I.login('app=io.ox/mail', o);
    
    await I.verifyUserSetup(userdata);


    // Next, log in to settings
    await I.goToSettings();

    // Reset the password
    I.see('Reset password');
    I.click('Reset password');
    I.waitForVisible('.modal-title');
    I.seeTextEquals('Reset Password', '.modal-title');  // Header
    I.click('.btn[data-action="reset"]');
    I.waitForInvisible('.modal-dialog');

    // Goto mail and wait for mail to arrive
    I.openApp('Mail');
    I.waitForVisible('.io-ox-mail-window .leftside');
    I.wait(1);
    I.click('#io-ox-refresh-icon');
    I.waitForVisible('.io-ox-mail-window .leftside ul li.unread');
    I.click('.io-ox-mail-window .leftside ul li.unread');

    //Pull the new temporary password from the email
    I.waitForVisible('.mail-detail-frame');
    I.switchTo('.mail-detail-frame');
    let newPass = await I.grabTextFrom('.bodyBox');
    I.switchTo();

    // Got back to settings and change the password
    await I.goToSettings();
    I.waitForVisible('#changePassword');
    I.click('#changePassword');
    I.waitForVisible('#oldpass');
    I.fillField('#oldpass', newPass);
    I.insertCryptPassword('#newpass1', userdata);
    I.insertCryptPassword('#newpass2', userdata);
    I.click('.btn[data-action="change"]');

    // Confirm good change of the temporary password
    I.waitForVisible('.io-ox-alert-success');
    I.seeTextEquals('Password changed successfully.', '.io-ox-alert-success');

    I.logout();

});