/**
 * This work is provided under the terms of the CREATIVE COMMONS PUBLIC
 * LICENSE. This work is protected by copyright and/or other applicable
 * law. Any use of the work other than as authorized under this license
 * or copyright law is prohibited.
 *
 * http://creativecommons.org/licenses/by-nc-sa/2.5/
 * © 2017 OX Software GmbH, Germany. info@open-xchange.com
 *
 * @author Greg Hill <greg.hill@open-xchange.com>
 */

/// <reference path="../../steps.d.ts" />

Feature('Office: Create encrypted documents');

Before(async function (users) {
    await users.create();
});

After(async function (users) {
    await users.removeAll();
});

Scenario('Office: Create an encrypted text document', async function (I, users) {

    const o = {
        user: users[0]
    };
    const userdata = o.user.userdata;

    await I.setupUser(o, true);
    await I.haveSetting('io.ox/office//isCheckSpellingPermanently', false, o);
    await o.user.hasCapability('guard-docs');

    I.login('app=io.ox/files', o);
    
    await I.verifyUserSetup(userdata);
    I.wait(1);
    I.waitForVisible('.dropdown-toggle[data-dropdown="io.ox/files/toolbar/new"]');
    I.click('.dropdown-toggle[data-dropdown="io.ox/files/toolbar/new"]');
    I.waitForVisible('.dropdown-menu [data-action="text-newblank"]');
    I.click('.dropdown-menu [data-action="text-newblank"]');

    I.wait(3);

    // Switch to office tab and add test text
    I.switchToNextTab();
    I.waitForVisible('.button[data-value="format"]', 60);
    I.waitForVisible('.page.formatted-content.user-select-text');
    I.wait(1);
    I.addToTextDocument('test');

    // Save as encrypted file
    I.click('.button[data-value="file"]');
    I.waitForVisible('.group[data-key="view/saveas/menu"]');
    I.wait(1);
    I.click('.group[data-key="view/saveas/menu"]');
    I.click('Save as (encrypted)');
    I.waitForVisible('#save-as-filename');
    I.wait(1);
    I.fillField('#save-as-filename', 'testTextEncr');
    I.click('Save');

    // Enter Guard password
    I.auth(userdata);

    // Office closes and re-opens.  Wait
    I.wait(5);
    I.waitForVisible('.page.formatted-content.user-select-text');

    // Close the office tab, find file in drive and click
    I.closeCurrentTab();
    I.waitForVisible('.visible-selection');
    I.click('.apptitle[aria-label="Refresh"]');
    I.wait(2);
    I.see('testTextEncr.docx.pgp', '.list-view-control');
    I.doubleClick('.file-type-guard');

    // Lets check we can read it
    I.auth(userdata);

    I.wait(2);
    I.switchToNextTab();

    I.waitForVisible('.page.formatted-content.user-select-text');
    I.waitForVisible('.button[data-value="format"]', 60);
    I.wait(1);
    I.see('test', '.page.formatted-content.user-select-text');

    // Closeup
    I.closeCurrentTab();
    I.wait(2);
    I.logout();

});

