/**
 * This work is provided under the terms of the CREATIVE COMMONS PUBLIC
 * LICENSE. This work is protected by copyright and/or other applicable
 * law. Any use of the work other than as authorized under this license
 * or copyright law is prohibited.
 *
 * http://creativecommons.org/licenses/by-nc-sa/2.5/
 * © 2017 OX Software GmbH, Germany. info@open-xchange.com
 *
 * @author Greg Hill <greg.hill@open-xchange.com>
 */

/// <reference path="../../steps.d.ts" />

Feature('Email Public Key Tests');

Before(async function (users) {
    await users.create();
    await users.create();  // Two users
});

After(async function (users) {
    await users.removeAll();
});

Scenario('Send plaintext public key', async function (I, users) {
    const o1 = {
        user: users[0]
    };
    const o2 = {
        user: users[1]
    };

    await I.setupUser(o1, true);
    await I.setupUser(o2);

    const userdata1 = o1.user.userdata;
    const userdata2 = o2.user.userdata;

    I.login('app=io.ox/mail', o1);
    I.waitForVisible('.io-ox-mail-window .window-body .classic-toolbar');

    I.verifyUserSetup(userdata1);  // Verify user has Guard setup
    
    // Test data
    var random = Math.floor((Math.random() * 100000));
    var subject = "Test Subject " + random;
    var data = "Test data " + random;

    // Open compose
    I.sendEmail(userdata2, subject, data, undefined, { unencrypted: true, attachKey: true });

    I.wait(2);

    // Logout and log back in as second user
    I.logout();
    I.login('app=io.ox/mail', o2);
    I.verifyUserSetup(userdata2);  // Verify user has Guard setup
    I.waitForVisible('.io-ox-mail-window .leftside');
    I.waitForVisible('.io-ox-mail-window .leftside ul li.unread');
    I.wait(1);  // Wait for Guard setup to complete
    I.click('.io-ox-mail-window .leftside ul li.unread');

    I.waitForVisible('.importKey');
    I.click('.importKey span');
    I.waitForVisible(".io-ox-alert-success");
    I.see('Added keys:');
    I.see("User IDs:");

    // OK, done
    I.logout();
});

Scenario('Send public key in encrypted email', async function (I, users) {
    const o1 = {
        user: users[0]
    };
    const o2 = {
        user: users[1]
    };

    await I.setupUser(o1, true);
    await I.setupUser(o2);

    const userdata1 = o1.user.userdata;
    const userdata2 = o2.user.userdata;

    I.login('app=io.ox/mail', o1);
    I.waitForVisible('.io-ox-mail-window .window-body .classic-toolbar');

    I.verifyUserSetup(userdata1);  // Verify user has Guard setup
    
    // Test data
    var random = Math.floor((Math.random() * 100000));
    var subject = "Test Subject " + random;
    var data = "Test data " + random;

    // Open compose
    I.sendEmail(userdata2, subject, data, undefined, { attachKey: true });

    I.wait(2);

    // Logout and log back in as second user
    I.logout();
    I.login('app=io.ox/mail', o2);
    I.waitForVisible('.io-ox-mail-window .leftside');
    I.waitForVisible('.io-ox-mail-window .leftside ul li.unread');
    I.click('.io-ox-mail-window .leftside ul li.unread');

    // Change temporary password
    I.changeTemporaryPassword(userdata2);

    I.waitForVisible('.btn[data-action="done"]');  // Wizard shows done
    I.click('.btn[data-action="done"]');

    // Verify decrypted
    I.verifyDecryptedMail(subject, data);

    // Check key import
    I.waitForVisible('.importKey');
    I.click('.importKey span');

    // Insert crypt password
    I.auth(userdata2);

    I.waitForVisible(".io-ox-alert-success");
    I.see('Added keys:');
    I.see("User IDs:");

    // OK, done
    I.logout();
});