/**
 * All content on this website (including text, images, source
 * code and any other original works), unless otherwise noted,
 * is licensed under a Creative Commons License.
 *
 * http://creativecommons.org/licenses/by-nc-sa/2.5/
 *
 * Copyright (C) 2016-2020 OX Software GmbH
 * Author Greg Hill <greg.hill@open-xchange.com>
 */

define('pgp_local/localDecryptor', [
    'pgp_local/register'
], function (local) {

    'use strict';

    var keyRing = window.keyRing;

    function checkLocal(folder, id, module) {
        var def = $.Deferred();

        local.loadPrivate();
        // If no keys, reject
        if (keyRing.privateKeys.keys.length === 0) {
            def.reject('no key');
        }
        require(['pgp_local/sessionHandler'], function (session) {
            session.getSessions(folder, id, module)
            .done(function (resp) {
                def.resolve(resp.data.encryptedSessionKeyPackets);
            })
            .fail(function (e) {
                def.reject(e);
            });
        });

        return def;
    }

    function checkIfHasKey(sessions) {
        var def = $.Deferred();
        require(['pgp_local/session'], function (session) {
            for (var i = 0; i < sessions.length; i++) {
                session.setSession(sessions[i]);
                if (session.hasKey()) {
                    def.resolve();
                    return;
                }
            }
            def.reject();
        });
        return def;
    }

    function tryDecrypt(sessions, password) {
        var def = $.Deferred();
        var decrypted;
        require(['pgp_local/session'], function (session) {
            for (var i = 0; i < sessions.length; i++) {
                session.setSession(sessions[i]);
                var result = session.decrypt(password);
                if (result === 'ok') {
                    decrypted = session.getDecrypted();
                    def.resolve(decrypted);
                    return;
                }
                if (result === 'badPassword') {
                    def.reject('badPassword');
                    return;
                }
            }
            def.reject();
        });
        return def;
    }

    return {
        checkLocal: checkLocal,
        tryDecrypt: tryDecrypt,
        checkIfHasKey: checkIfHasKey
    };

});
