/**
 * This work is provided under the terms of the CREATIVE COMMONS PUBLIC
 * LICENSE. This work is protected by copyright and/or other applicable
 * law. Any use of the work other than as authorized under this license
 * or copyright law is prohibited.
 *
 * http://creativecommons.org/licenses/by-nc-sa/2.5/
 *
 * © 2016 OX Software GmbH, Germany. info@open-xchange.com
 *
 * @author Greg Hill <greg.hill@open-xchange.com>
 */

define('oxguard/settings/views/downloadPrivateView', [
    'io.ox/core/extensions',
    'io.ox/backbone/views/modal',
    'oxguard/oxguard_core',
    'io.ox/core/yell',
    'gettext!oxguard',
    'less!oxguard/settings/style'
], function (ext, ModalView, core, yell, gt) {

    'use strict';

    var POINT = 'oxguard/settings/downloadPrivate',
        INDEX = 0;

    function open(keyid) {
        return openModalDialog(keyid);
    }

    function openModalDialog(keyid) {

        return new ModalView({
            async: true,
            point: POINT,
            title: gt('Download Key'),
            width: 450,
            model: new Backbone.Model({ 'data': keyid })
        })
        .inject({
        })
        .build(function () {
        })
        .addCloseButton()
        .open();
    }

    ext.point(POINT).extend(
        {
            index: INDEX += 100,
            id: 'header',
            render: function () {
                var label = $('<label>').append($('<p>').append(gt('Download your private key for use with other email programs')))
                            .append($('<p>').append(gt('Do not distribute this key.  It is for your use only')));
                this.$body.append(
                    label
                );
            }
        },
        {
            index: INDEX += 100,
            id: 'downloadPrivate',
            render: function (baton) {
                var div = $('<div>');
                var button = $('<button type="button" class="upload-view btn btn-primary" id="downloadPrivate">')
                    .text(gt('Download PGP Private Key'))
                    .on('click', function (e) {
                        e.preventDefault();
                        downloadPrivate(baton.model.get('data'), false)
                        .done(function () {
                            if (!baton.view.disposed) baton.view.close();
                        })
                        .fail(function (ex) {
                            yell('error', ex);
                        });
                    });
                this.$body.append(
                    div.append(button)
                );
            }
        },
        {
            index: INDEX += 100,
            id: 'downloadPublicPrivate',
            render: function (baton) {
                var div = $('<div>');
                var button = $('<button type="button" class="upload-view btn btn-primary" id="downloadPrivate">')
                    .text(gt('Download Public and Private Key'))
                    .on('click', function (e) {
                        e.preventDefault();
                        downloadPrivate(baton.model.get('data'), true)
                        .done(function () {
                            if (!baton.view.disposed) baton.view.close();
                        })
                        .fail(function (ex) {
                            yell('error', ex);
                        });
                    });
                this.$body.append(
                    div.append(button)
                );
            }
        },
        {
            index: INDEX += 100,
            id: 'downloadPublic',
            render: function (baton) {
                var div = $('<div>');
                var button = $('<button type="button" class="upload-view btn btn-primary" id="downloadPrivate">')
                    .text(gt('Download PGP Public Key'))
                    .on('click', function (e) {
                        e.preventDefault();
                        downloadPublic(baton.model.get('data'));
                        if (!baton.view.disposed) baton.view.close();
                    });
                this.$body.append(
                    div.append(button)
                );
            }
        }

    );

    function downloadPrivate(id, both) {
        var def = $.Deferred();
        core.getPassword(undefined, false)
        .done(function (pass) {
            core.verifyPassword(pass.password, id).then(function () {
                /// get the key
                $('#guardTemp').remove(); // Clear any previous
                core.metrics('settings', 'download-private');
                var params = '&keyid=' + id +
                '&keyType=' + (both ? 'public_private' : 'private') +
                '&session=' + ox.session;
                var link = ox.apiRoot + '/oxguard/keys?action=downloadKey' + params;
                var form = $('<form method="POST" id="guardTemp" action="' + link + '" target="_blank">');
                var input = $('<input type="hidden" name="password">');
                input.attr('value', pass.password);
                form.append(input);
                $('#tmp').append(
                    form
                );
                def.resolve();
                form.submit();
            }, def.reject);
        });
        return def;
    }

    function downloadPublic(id) {
        core.metrics('settings', 'download-public-key');
        $('#guardTemp').remove(); // Clear any previous
        core.metrics('settings', 'download-private');
        var params = '&keyType=public' +
        '&session=' + ox.session;
        if (id) params += '&keyid=' + id;
        var link = ox.apiRoot + '/oxguard/keys?action=downloadKey' + params;
        var form = $('<form method="POST" id="guardTemp" action="' + link + '" target="_blank">');
        $('#tmp').append(
            form
        );
        form.submit();
    }

    return {
        open: open,
        downloadPublic: downloadPublic
    };

});
