/**
 * This work is provided under the terms of the CREATIVE COMMONS PUBLIC
 * LICENSE. This work is protected by copyright and/or other applicable
 * law. Any use of the work other than as authorized under this license
 * or copyright law is prohibited.
 *
 * http://creativecommons.org/licenses/by-nc-sa/2.5/
 *
 * © 2016 OX Software GmbH, Germany. info@open-xchange.com
 *
 * @author Greg Hill <greg.hill@open-xchange.com>
 */

define('oxguard/settings/views/deletePublicView', [
    'io.ox/core/extensions',
    'io.ox/backbone/views/modal',
    'oxguard/oxguard_core',
    'io.ox/core/yell',
    'oxguard/core/og_http',
    'gettext!oxguard',
    'less!oxguard/settings/style'
], function (ext, ModalView, core, yell, http, gt) {

    'use strict';

    var POINT = 'oxguard/settings/deletePublic',
        INDEX = 0;

    var dialog;

    function open(keyId) {
        dialog = openModalDialog(keyId);
        return dialog;
    }

    function openModalDialog(keyId) {

        return new ModalView({
            async: true,
            point: POINT,
            title: gt('Delete Public Key'),
            width: 400,
            enter: 'cancel'
        })
        .inject({
        })
        .build(function () {
        })
        .addAlternativeButton({ label: gt('Delete'), action: 'delete' })
        .on('delete', function () {
            var dialog = this;
            deletePublic(keyId)
            .done(function () {
                yell('success', gt('Key Deleted'));
                dialog.close();
                $('#refreshuserkeys').click();
            })
            .fail(function (e) {
                yell('error', e);
                dialog.close();
            });
        })
        .addCloseButton()
        .open();
    }

    ext.point(POINT).extend(
        {
            index: INDEX += 100,
            id: 'header',
            render: function () {
                var label = $('<label>').append(gt('Please verify you want to delete this key'))
                    .append('<br>');
                this.$body.append(
                    label
                );
            }
        }

    );

    function deletePublic(keyid) {
        var def = $.Deferred();
        var json = {
            userid: ox.user_id,
            cid: ox.context_id,
            keyid: keyid
        };
        core.metrics('settings', 'delete-public-key');
        http.simplePost(ox.apiRoot + '/oxguard/keys?action=delete', '&keyid=' + keyid, json)
        .done(function () {
            def.resolve();
        })
        .fail(function () {
            def.reject(gt('Failed to delete'));
        });
        return def;
    }

    return {
        open: open
    };

});
