/**
 * This work is provided under the terms of the CREATIVE COMMONS PUBLIC
 * LICENSE. This work is protected by copyright and/or other applicable
 * law. Any use of the work other than as authorized under this license
 * or copyright law is prohibited.
 *
 * http://creativecommons.org/licenses/by-nc-sa/2.5/
 *
 * © 2016 OX Software GmbH, Germany. info@open-xchange.com
 *
 * @author Greg Hill <greg.hill@open-xchange.com>
 */

define('oxguard/settings/views/autoCryptKeysView', [
    'io.ox/backbone/views',
    'io.ox/core/extensions',
    'io.ox/backbone/mini-views',
    'io.ox/backbone/views/modal',
    'io.ox/core/settings/util',
    'io.ox/core/yell',
    'oxguard/pgp/keyDetails',
    'oxguard/core/og_http',
    'oxguard/oxguard_core',
    'gettext!oxguard'
], function (views, ext, mini, ModalView, util, yell, pubkeys, og_http, core, gt) {

    'use strict';

    var POINT = 'oxguard/settings/autoCryptkeys',
        INDEX = 0;

    function open() {
        return openModalDialog();
    }

    function openModalDialog() {

        return new ModalView({
            async: true,
            point: POINT,
            title: gt('Autocrypt Keys'),
            id: 'autoCryptList',
            width: 560
        })
        .inject({
            doChange: function () {
            }
        })
        .build(function () {

        })
        .addButton({ label: gt('Done'), action: 'done' })
        .on('done', function () {
            this.close();
        })
        .open();
    }

    ext.point(POINT).extend(
        // Draw Div with list keys
        {
            index: INDEX += 100,
            id: 'header',
            render: function () {
                var div = $('<div class="autocryptHeader">');
                this.$header.append(
                    div.append($('<span>').append(
                        gt('These keys have been collected from email headers.  Keys are used for encryption, but not signatures verification until the key is verified by you.'))));
            }
        },
        {
            index: INDEX += 100,
            id: 'switch',
            render: function () {
                var div = $('<div>');
                this.$body.append(
                    div.append(pubkeys.listPublic({ id: 'autoCrypt', title: gt('Collected keys'), minimal: true }))
                );
            }
        }
    );

    return {
        open: open
    };

});
