/**
 * This work is provided under the terms of the CREATIVE COMMONS PUBLIC
 * LICENSE. This work is protected by copyright and/or other applicable
 * law. Any use of the work other than as authorized under this license
 * or copyright law is prohibited.
 *
 * http://creativecommons.org/licenses/by-nc-sa/2.5/
 *
 * © 2016 OX Software GmbH, Germany. info@open-xchange.com
 *
 * @author Greg Hill <greg.hill@open-xchange.com>
 */

define('oxguard/portal/register', [
    'io.ox/core/extensions'
], function (ext) {

    'use strict';

    ////////// Extension point portal

    ext.point('io.ox/portal/widget/myfiles').extend({
        id: 'OxGuardRecentFiles',
        index: 1000000,
        preview: function () {
            var content = $(this).find('.list-unstyled');
            setupGuard(content);
        }
    });

    ext.point('io.ox/portal/widget/recentfiles').extend({
        id: 'OxGuardRecentFiles',
        index: 1000000,
        preview: function () {
            var content = $(this).find('.list-unstyled');
            setupGuard(content);
        }
    });

    function setupGuard(content) {
        content.unbind('click');
        content.on('click', 'li.item', function (e) {
            e.stopPropagation();
            var item = $(e.currentTarget).data('item');
            if (isEncrypted(item)) {
                require(['oxguard/files/register', 'io.ox/files/api'], function (files, filesAPI) {
                    var items = $(e.delegateTarget).data('items');
                    filesAPI.get(item).done(function (data) {
                        var models = filesAPI.resolve(items, false),
                            collection = new Backbone.Collection(models);
                        var baton = new ext.Baton({ data: data, collection: collection });
                        files.viewFile(baton);
                    });
                });
            } else {
                var items = $(e.delegateTarget).data('items');
                require(['io.ox/core/viewer/main', 'io.ox/files/api'], function (Viewer, filesAPI) {
                    filesAPI.get(item).done(function (data) {
                        var models = filesAPI.resolve(items, false),
                            collection = new Backbone.Collection(models),
                            viewer = new Viewer();
                        var baton = new ext.Baton({ data: data, collection: collection });
                        viewer.launch({ selection: baton.data, files: baton.collection.models });
                    });
                });
            }

        });
    }

    function isEncrypted(item) {
        if (item.meta) {
            if (item.meta.Encrypted === true) return (true);
        }
        if (item.filename) {
            if (item.filename.indexOf('.pgp') > 0) return (true);
        }
        return (false);
    }
});
