/*
 *
 *    OPEN-XCHANGE legal information
 *
 *    All intellectual property rights in the Software are protected by
 *    international copyright laws.
 *
 *
 *    In some countries OX, OX Open-Xchange, open xchange and OXtender
 *    as well as the corresponding Logos OX Open-Xchange and OX are registered
 *    trademarks of the OX Software GmbH. group of companies.
 *    The use of the Logos is not covered by the GNU General Public License.
 *    Instead, you are allowed to use these Logos according to the terms and
 *    conditions of the Creative Commons License, Version 2.5, Attribution,
 *    Non-commercial, ShareAlike, and the interpretation of the term
 *    Non-commercial applicable to the aforementioned license is published
 *    on the web site http://www.open-xchange.com/EN/legal/index.html.
 *
 *    Please make sure that third-party modules and libraries are used
 *    according to their respective licenses.
 *
 *    Any modifications to this package must retain all copyright notices
 *    of the original copyright holder(s) for the original code used.
 *
 *    After any such modifications, the original and derivative code shall remain
 *    under the copyright of the copyright holder(s) and/or original author(s)per
 *    the Attribution and Assignment Agreement that can be located at
 *    http://www.open-xchange.com/EN/developer/. The contributing author shall be
 *    given Attribution for the derivative code and a license granting use.
 *
 *     Copyright (C) 2016-2020 OX Software GmbH.
 *     Mail: info@open-xchange.com
 *
 *
 *     This program is free software; you can redistribute it and/or modify it
 *     under the terms of the GNU General Public License, Version 2 as published
 *     by the Free Software Foundation.
 *
 *     This program is distributed in the hope that it will be useful, but
 *     WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 *     or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License
 *     for more details.
 *
 *     You should have received a copy of the GNU General Public License along
 *     with this program; if not, write to the Free Software Foundation, Inc., 59
 *     Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 */

package com.openexchange.git;

import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import com.openexchange.git.conflict.Solver;
import com.openexchange.git.conflict.Solvers;
import com.openexchange.git.data.Conflict;
import com.openexchange.git.data.File;

/**
 * Main class of the Git merge utility.
 *
 * @author <a href="mailto:marcus.klein@open-xchange.com">Marcus Klein</a>
 */
public final class Merge {

    private static final Log LOG = LogFactory.getLog(Merge.class);

    private Merge() {
        super();
    }

    public static void main(String[] args) throws IOException, MergeException {
        if (0 == args.length) {
            System.out.println("Please provide all files to merge as arguments list.");
        }
        // TODO find files that need to be merged himself
        for (String fileName : args) {
            java.io.File file = new java.io.File(fileName);
            if (!file.exists()) {
                LOG.error("File " + file.getAbsolutePath() + " does not exist.");
                continue;
            }
            File myFile = new File(file);
            LOG.info("Trying to merge file " + file.getPath());
            boolean solved;
            do {
                solved = false;
                Iterator<Conflict> iter = myFile.conflictIterator();
                while (iter.hasNext() && !solved) {
                    Conflict conflict = iter.next();
                    for (Solver solver : Solvers.getInstance().getSolvers()) {
                        if (solver.applies(conflict)) {
                            List<String> replacement = solver.solve(conflict);
                            myFile.solve(conflict, replacement);
                            myFile.save();
                            solved = true;
                            break;
                        }
                    }
                }
            } while (solved);
            Iterator<Conflict> iter = myFile.conflictIterator();
            if (!solved && iter.hasNext()) {
                LOG.info("Was not able to solve the following conflict.");
                LOG.info(iter.next().toString());
                System.exit(1);
            }
            LOG.info(file.getPath() + " merged.");
            // TODO git add
        }
    }
}
