/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.obs.gradle.plugin;

import com.openexchange.obs.gradle.plugin.Repository;
import groovy.lang.Closure;
import javax.inject.Inject;
import org.gradle.api.Action;
import org.gradle.api.NamedDomainObjectContainer;
import org.gradle.api.NamedDomainObjectFactory;
import org.gradle.api.provider.Property;

public class Project {
    private String name;
    private final Property<String> prjconf;
    private final NamedDomainObjectContainer<Repository> repositoryContainer;
    private static final String DEFAULT_CONFIGURATION = "Macros:\n%vendor Open-Xchange\n";

    @Inject
    public Project(org.gradle.api.Project project) {
        this.prjconf = project.getObjects().property(String.class).convention((Object)DEFAULT_CONFIGURATION);
        this.repositoryContainer = project.container(Repository.class, (NamedDomainObjectFactory)new NamedDomainObjectFactory<Repository>(){

            public Repository create(String name) {
                return new Repository(name);
            }
        });
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Property<String> getPrjconf() {
        return this.prjconf;
    }

    public void prjconf(Action<? super Property<String>> action) {
        action.execute(this.prjconf);
    }

    @Deprecated
    public void repositories(Closure<?> closure) {
        this.repositoryContainer.configure(closure);
    }

    public void repositories(Action<? super NamedDomainObjectContainer<Repository>> action) {
        action.execute(this.repositoryContainer);
    }

    public com.openexchange.obs.api.Project convert(String user) {
        assert (null != this.name);
        com.openexchange.obs.api.Project project = new com.openexchange.obs.api.Project(this.name, this.name, user);
        for (Repository repository : this.repositoryContainer) {
            project.addRepository(repository.convert());
        }
        project.setBuildConfiguration((String)this.prjconf.get());
        return project;
    }
}

