/*
 * @copyright Copyright (c) OX Software GmbH, Germany <info@open-xchange.com>
 * @license AGPL-3.0
 *
 * This code is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with OX App Suite.  If not, see <https://www.gnu.org/licenses/agpl-3.0.txt>.
 *
 * Any use of the work other than as authorized under this license or copyright law is prohibited.
 *
 */

package com.openexchange.guard.mail.service.impl;

import com.openexchange.capabilities.CapabilityService;
import com.openexchange.exception.OXException;
import com.openexchange.guard.internal.authentication.GuardAuthenticationToken;
import com.openexchange.mail.Protocol;
import com.openexchange.mail.api.AbstractProtocolProperties;
import com.openexchange.mail.api.AllMailProvider;
import com.openexchange.mail.api.IMailFolderStorage;
import com.openexchange.mail.api.IMailMessageStorage;
import com.openexchange.mail.api.MailAccess;
import com.openexchange.mail.api.MailProvider;
import com.openexchange.mail.mime.crypto.PGPMailRecognizer;
import com.openexchange.session.Session;

/**
 * {@link GuardAllMailProvider}
 *
 * @author <a href="mailto:benjamin.gruedelbach@open-xchange.com">Benjamin Gruedelbach</a>
 * @since v7.8.4
 */
public class GuardAllMailProvider extends AllMailProvider {

    private final PGPMailRecognizer pgpMailRecognizer;
    private final GuardAuthenticationToken authToken;
    private final CapabilityService capabilityService;

    /**
     * Initializes a new {@link GuardAllMailProvider}.
     * @param pgpMailRecognizer A {@link PGPMailRecognizer} object recognizing PGP messages.
     */
    public GuardAllMailProvider(PGPMailRecognizer pgpMailRecognizer, CapabilityService capabilityService, GuardAuthenticationToken authToken) {
        this.pgpMailRecognizer = pgpMailRecognizer;
        this.capabilityService = capabilityService;
        this.authToken = authToken;
    }

    /* (non-Javadoc)
     * @see com.openexchange.mail.api.AllMailProvider#getDelegatingProvider(com.openexchange.mail.api.MailProvider)
     */
    @Override
    public MailProvider getDelegatingProvider(MailProvider realProvider) {
        return new GuardMailProvider(realProvider, pgpMailRecognizer, capabilityService, authToken);
    }

    /* (non-Javadoc)
     * @see com.openexchange.mail.api.MailProvider#getProtocol()
     */
    @Override
    public Protocol getProtocol() {
        return Protocol.PROTOCOL_ALL;
    }

    /* (non-Javadoc)
     * @see com.openexchange.mail.api.MailProvider#createNewMailAccess(com.openexchange.session.Session)
     */
    @Override
    public MailAccess<?, ?> createNewMailAccess(Session session) throws OXException {
        return null;
    }

    /* (non-Javadoc)
     * @see com.openexchange.mail.api.MailProvider#createNewMailAccess(com.openexchange.session.Session, int)
     */
    @Override
    public MailAccess<? extends IMailFolderStorage, ? extends IMailMessageStorage> createNewMailAccess(Session session, int accountId) throws OXException {
        return null;
    }

    /* (non-Javadoc)
     * @see com.openexchange.mail.api.MailProvider#getProtocolProperties()
     */
    @Override
    protected AbstractProtocolProperties getProtocolProperties() {
        return new AbstractProtocolProperties() {

            @Override
            protected void resetFields() {
            }

            @Override
            protected void loadProperties0() throws OXException {
            }
        };
    }

}
