package com.openexchange.ant.tasks;

import java.io.File;
import java.io.IOException;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import com.openexchange.build.utils.Tools;

/**
 * Reads an Eclipse launcher file and tries to find the given bundle within the target_bundles or workspace_bundles stringAttributes. If the
 * Bundle is found, its start level is read and exposed as the given property.
 */
public class ReadStartLevel extends Task {

    private File launcher;
    private String bundle;
    private String propertyName;

    public ReadStartLevel() { super(); }

    public void setLauncher(File launcher) { this.launcher = launcher; }

    public void setBundle(String bundle) { this.bundle = bundle; }

    public void setPropertyName(String propertyName) { this.propertyName = propertyName; }

    @Override
    public void execute() throws BuildException {
        if (null == launcher) {
            throw new BuildException("You need to define the launcher attribute.");
        }
        if (null == bundle) {
            throw new BuildException("You need to define the bundle, that start level should be read from the launcher file.");
        }
        if (null == propertyName) {
            throw new BuildException("You need to define the propertyName, where this task should store the start level.");
        }
        final Document document;
        try {
            document = com.openexchange.ant.Tools.readXML(launcher);
        } catch (IOException e) {
            throw new BuildException("Failed to read launcher file.", e);
        }
        final Element launchConfigurationElement = document.getDocumentElement();
        final NodeList childs = launchConfigurationElement.getChildNodes();
        String startLevel = null;
        for (int i = 0; i < childs.getLength() && null == startLevel; i++) {
            final Node node = childs.item(i);
            if ("stringAttribute".equals(node.getNodeName())) {
                final NamedNodeMap attributes = node.getAttributes();
                final Node key = attributes.getNamedItem("key");
                final Node value = attributes.getNamedItem("value");
                if (null == key || null == value) {
                    continue;
                }
                if ("target_bundles".equals(key.getNodeValue()) || "workspace_bundles".equals(key.getNodeValue())) {
                    for (String tmp : Tools.split(value.getNodeValue(), ',')) {
                        int pos = tmp.indexOf('@');
                        if (pos <= 0) {
                            throw new BuildException("Can not parse \"" + tmp + "\".");
                        }
                        if (bundle.equals(tmp.substring(0, pos))) {
                            int pos2 = tmp.indexOf(':', pos);
                            if (pos2 <= 0) {
                                throw new BuildException("Can not parse \"" + tmp + "\".");
                            }
                            startLevel = tmp.substring(pos + 1, pos2);
                            if ("default".equals(startLevel)) {
                                startLevel = "start";
                            }
                            break;
                        }
                    }
                }
            }
        }
        if (null == startLevel) {
            startLevel = "start";
        }
        getProject().setInheritedProperty(propertyName, startLevel);
    }
}
