/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.osgi.ant;

import com.openexchange.osgi.Tools;
import com.openexchange.osgi.data.AbstractModule;
import com.openexchange.osgi.data.DependenciesSorter;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.types.Path;

public class ComputeBuildOrder
extends Task {
    private File dir;
    private String propertyName;
    private String projectList;
    private boolean strict = true;
    private String buildType;
    private Path classpath;

    public void setProjectList(String projectList) {
        this.projectList = projectList;
    }

    public void setStrict(boolean strict) {
        this.strict = strict;
    }

    public void setBuildType(String buildType) {
        this.buildType = buildType;
    }

    public void setPropertyName(String propertyName) {
        this.propertyName = propertyName;
    }

    public void setDir(File dir) {
        this.dir = dir;
    }

    public Path createClasspath() {
        this.classpath = new Path(this.getProject());
        return this.classpath;
    }

    public void execute() throws BuildException {
        List<AbstractModule> sortedModules;
        List<AbstractModule> classpathModules;
        this.log("using classpath: " + this.classpath, 2);
        try {
            classpathModules = com.openexchange.osgi.ant.Tools.readClasspathModules(this.classpath);
        }
        catch (IOException e) {
            throw new BuildException(e.getMessage(), (Throwable)e);
        }
        ArrayList<AbstractModule> appModules = new ArrayList<AbstractModule>();
        for (Object split : com.openexchange.build.utils.Tools.split((String)this.projectList, (char)',')) {
            try {
                appModules.add(Tools.readModule(classpathModules, new File(this.dir, (String)split)));
            }
            catch (IOException e) {
                throw new BuildException(e.getMessage(), (Throwable)e);
            }
        }
        ArrayList<AbstractModule> allModules = new ArrayList<AbstractModule>(classpathModules.size() + appModules.size());
        allModules.addAll(classpathModules);
        allModules.addAll(appModules);
        this.log("all modules: " + allModules, 2);
        for (AbstractModule module : allModules) {
            try {
                module.computeDependencies(Tools.calculateModulesByName(allModules), Tools.calculateModulesByPackage(allModules), Tools.calculateModulesByFilename(allModules), this.strict);
            }
            catch (Exception e) {
                throw new BuildException(e.getMessage(), (Throwable)e);
            }
        }
        try {
            sortedModules = new DependenciesSorter().sortDependencies(classpathModules, appModules);
        }
        catch (Exception e) {
            throw new BuildException(e.getMessage(), (Throwable)e);
        }
        this.log("sorted modules: " + sortedModules, 2);
        sortedModules.removeAll(classpathModules);
        this.log("sorted modules without classpath: " + sortedModules, 2);
        String moduleNamesList = com.openexchange.build.utils.Tools.join(sortedModules, (String)",");
        this.getProject().setInheritedProperty(this.propertyName, moduleNamesList);
        if ("tests".equals(this.buildType) || "osgiTests".equals(this.buildType)) {
            for (AbstractModule module : sortedModules) {
                com.openexchange.osgi.ant.Tools.setProjectProperties(this.getProject(), module, this.buildType);
            }
        }
    }
}

