/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.obs.gradle.tasks;

import com.openexchange.obs.BuildFailureException;
import com.openexchange.obs.api.BuildServiceClient;
import com.openexchange.obs.api.BuildServiceException;
import com.openexchange.obs.api.Code;
import com.openexchange.obs.api.Result;
import com.openexchange.obs.api.Tools;
import com.openexchange.obs.gradle.plugin.BuildserviceExtension;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import javax.inject.Inject;
import org.gradle.api.DefaultTask;
import org.gradle.api.GradleException;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.api.provider.ListProperty;
import org.gradle.api.tasks.TaskAction;

public class Wait4Project
extends DefaultTask {
    private static final Logger logger = Logging.getLogger(Wait4Project.class);
    private final BuildserviceExtension extension;
    private int sleep = 1000;
    private final ListProperty<String> projectNames;

    @Inject
    public Wait4Project(BuildserviceExtension extension) {
        this.extension = extension;
        this.projectNames = this.getProject().getObjects().listProperty(String.class);
    }

    @TaskAction
    public void wait4Project() {
        this.projectNames.add((Object)this.extension.getProject().getName());
        try {
            BuildServiceClient client = new BuildServiceClient(this.extension.getUrl(), this.extension.getLogin(), this.extension.getPassword());
            logger.info("Checking build status for all packages on {}.", (Object)this.extension.getProject().getName());
            HashMap<String, Result[]> tmpResults = new HashMap<String, Result[]>();
            boolean didNeverBuild = true;
            long lastLog = System.currentTimeMillis();
            try {
                do {
                    if (!tmpResults.isEmpty() && System.currentTimeMillis() - lastLog > 30000L) {
                        lastLog = System.currentTimeMillis();
                        if (didNeverBuild) {
                            logger.info("Still waiting for the build to start.");
                        } else {
                            logger.info("Still waiting for {} packages to finish build.", (Object)Tools.packagesToBuild(tmpResults));
                        }
                    }
                    tmpResults.clear();
                    Thread.sleep(this.sleep);
                    for (String projectName : (List)this.projectNames.get()) {
                        Result[] projectResults = client.getProjectStatus(projectName, null);
                        Tools.checkResultsForState(projectResults, projectName, Code.FAILED);
                        tmpResults.put(projectName, projectResults);
                    }
                    if (Tools.isDirty(Tools.combine(tmpResults)) || !Tools.isProjectBuilding(Tools.combine(tmpResults))) continue;
                    didNeverBuild = false;
                } while ((Tools.isProjectBuilding(Tools.combine(tmpResults)) || didNeverBuild) && !Tools.allPublishedAndSomePackageUnresolved(Tools.combine(tmpResults)));
                for (String projectName : (List)this.projectNames.get()) {
                    Tools.checkResultsForState(Tools.combine(tmpResults), projectName, Code.UNRESOLVABLE);
                }
            }
            catch (BuildFailureException e) {
                switch (e.getStatus().getCode()) {
                    case FAILED: {
                        logger.error(client.getPackageLogByName(e.getProjectName(), e.getResult().getRepository().getName(), e.getResult().getArch(), e.getStatus().getPackageName()));
                        break;
                    }
                    case UNRESOLVABLE: {
                        logger.error(e.toString());
                    }
                }
                throw new GradleException(e.getMessage(), (Throwable)e);
            }
        }
        catch (IOException e) {
            throw new GradleException(e.getMessage(), (Throwable)e);
        }
        catch (BuildServiceException e) {
            throw new GradleException(e.getMessage(), (Throwable)e);
        }
        catch (InterruptedException e) {
            throw new GradleException(e.getMessage(), (Throwable)e);
        }
    }
}

