/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.obs.gradle.tasks;

import com.openexchange.obs.api.BuildServiceClient;
import com.openexchange.obs.api.BuildServiceException;
import com.openexchange.obs.api.Project;
import com.openexchange.obs.api.Repository;
import com.openexchange.obs.gradle.plugin.BuildserviceExtension;
import java.util.HashSet;
import javax.inject.Inject;
import org.gradle.api.DefaultTask;
import org.gradle.api.GradleException;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.api.tasks.TaskAction;

public class CreateProject
extends DefaultTask {
    private final Logger logger = Logging.getLogger(CreateProject.class);
    private final BuildserviceExtension extension;

    @Inject
    public CreateProject(BuildserviceExtension extension) {
        this.extension = extension;
    }

    @TaskAction
    public void doExecute() throws GradleException {
        try {
            BuildServiceClient client = new BuildServiceClient(this.extension.getUrl(), this.extension.getLogin(), this.extension.getPassword());
            Project obsProject = this.extension.getProject().convert(this.extension.getLogin());
            if (!client.existsProject(obsProject)) {
                this.logger.warn("Creating project \"" + obsProject.getName() + "\" on build service.");
                client.createProject(obsProject);
            } else if (!client.getProjectConfig(obsProject.getName()).equals(obsProject.getBuildConfiguration())) {
                this.logger.warn("Project \"" + obsProject.getName() + "\" already exists on build service but has different config.");
                this.logger.warn("Project \"" + obsProject.getName() + "\" updated on build service.");
                client.createProject(obsProject);
            } else {
                this.logger.warn("Project \"" + obsProject.getName() + "\" already exists on build service.");
                Project currentProject = client.getRepositoryList(obsProject.getName());
                HashSet<Repository> currentRepositories = new HashSet<Repository>();
                this.logger.warn("currently used repositories on OBS: ");
                for (Repository r : currentProject.getRepositories()) {
                    boolean disabled = false;
                    for (String disabledRepo : currentProject.getDisabledRepositories()) {
                        if (!disabledRepo.equals(r.getName())) continue;
                        disabled = true;
                        break;
                    }
                    if (disabled) continue;
                    this.logger.warn(r.toString());
                    currentRepositories.add(r);
                }
                this.logger.warn("needed repositories: ");
                HashSet<Repository> neededRepositories = new HashSet<Repository>();
                for (Repository r : obsProject.getRepositories()) {
                    boolean disabled = false;
                    for (String disabledRepo : obsProject.getDisabledRepositories()) {
                        if (!disabledRepo.equals(r.getName())) continue;
                        disabled = true;
                        break;
                    }
                    if (disabled) continue;
                    this.logger.warn(r.toString());
                    neededRepositories.add(r);
                }
                if (!currentRepositories.equals(neededRepositories)) {
                    client.createProject(obsProject);
                    this.logger.warn("Project \"" + obsProject.getName() + "\" updated on build service.");
                }
            }
        }
        catch (BuildServiceException e) {
            throw new GradleException(e.getMessage(), (Throwable)e);
        }
    }
}

