/*
 *
 *  Copyright (C) 2012 Open-Xchange, Inc. All rights reserved.
 *
 *  This program is proprietary software and licensed to you under Open-Xchange
 *  Inc's Software License Agreement.
 *
 *  In some countries OX, OX Open-Xchange, open-xchange and OXtender as well as
 *  the corresponding Logos OX Open-Xchange and OX are registered trademarks of
 *  the Open-Xchange, Inc. group of companies.
 *
 */

package com.openexchange.documentconverter;

import java.io.IOException;
import java.net.MalformedURLException;
import java.util.HashMap;

//--------
//- IJob -
//--------

/**
 * {@link IJob}
 *
 * @author <a href="mailto:kai.ahrens@open-xchange.com">Kai Ahrens</a>
 */
public interface IJob {

    /**
     * @return The hash value, upon which this job (-result) can be uniquely identified
     */
    public String getHash();

    /**
     * @param jobProperties Additional job properties to be added to this job; may be called more than once
     */
    void addJobProperties(HashMap<String, Object> jobProperties);

    /**
     * @return The current job properties
     */
    HashMap<String, Object> getJobProperties();

    /**
     * @param jobProperties Additional job properties to be added to this job; may be called more than once
     */
    void addResultProperties(HashMap<String, Object> jobResultProperties);

    /**
     * @return The current job properties
     */
    HashMap<String, Object> getResultProperties();

    /**
     * This method will be called in order to let the job do the real work
     *
     * @param serverInstance The instance which triggers this job execution
     * @return true In case the execution succeeeded
     * @throws com.sun.star.lang.DisposedException
     * @throws InterruptedException
     * @throws IOException
     * @throws MalformedURLException
     * @throws Exception
     */
    boolean execute(IInstance serverInstance) throws com.sun.star.lang.DisposedException, InterruptedException, IOException, MalformedURLException, Exception;
}
