/*
 *
 *  Copyright (C) 2012 Open-Xchange, Inc. All rights reserved.
 *
 *  This program is proprietary software and licensed to you under Open-Xchange
 *  Inc's Software License Agreement.
 *
 *  In some countries OX, OX Open-Xchange, open-xchange and OXtender as well as
 *  the corresponding Logos OX Open-Xchange and OX are registered trademarks of
 *  the Open-Xchange, Inc. group of companies.
 *
 */

package com.openexchange.documentconverter;

import java.net.URL;

//-------------------
//- CacheDescriptor -
//-------------------

/**
 * {@link CacheDescriptor}
 *
 * @author <a href="mailto:kai.ahrens@open-xchange.com">Kai Ahrens</a>
 */
public class CacheDescriptor {

    /**
     * the path to the directory of the cache; if this directory does't exist, it will be created; the directory shouldn't contain any other
     * objects, since it is up to the implementation to remove this directory or change it in any way; the cache implementation is the owner
     * of this directory after successful initialization; the path to this directory and all contained files needs to have write permission
     * for the account of the user who owns the process
     */
    public String cacheDirectory = null;

    /**
     * the lower limit for the size of the volume that should not be occupied by the cache
     */
    public long minimumFreeVolumeSize = 0;

    /**
     * the upper limit for the size of all persistent files within the cache directory; -1 for no upper limit
     */
    public long maximumPersistSize = -1;

    /**
     * the maximum number of objects to be cached at all; -1 for no upper limit
     */
    public long maximumEntryCount = -1;

    /**
     * the timeout in milliseconds for the cached objects to be removed; 0 to disable the timeout based removal of cached objects
     */
    public long timeoutMilliseconds = 0;

    /**
     * the timeout in milliseconds for the cached objects to be removed; 0 to disable the timeout based removal of cached objects
     */
    public URL[] remoteCacheUrls = null;
}
