/*
 *
 *    OPEN-XCHANGE legal information
 *
 *    All intellectual property rights in the Software are protected by
 *    international copyright laws.
 *
 *
 *    In some countries OX, OX Open-Xchange, open xchange and OXtender
 *    as well as the corresponding Logos OX Open-Xchange and OX are registered
 *    trademarks of the Open-Xchange, Inc. group of companies.
 *    The use of the Logos is not covered by the GNU General Public License.
 *    Instead, you are allowed to use these Logos according to the terms and
 *    conditions of the Creative Commons License, Version 2.5, Attribution,
 *    Non-commercial, ShareAlike, and the interpretation of the term
 *    Non-commercial applicable to the aforementioned license is published
 *    on the web site http://www.open-xchange.com/EN/legal/index.html.
 *
 *    Please make sure that third-party modules and libraries are used
 *    according to their respective licenses.
 *
 *    Any modifications to this package must retain all copyright notices
 *    of the original copyright holder(s) for the original code used.
 *
 *    After any such modifications, the original and derivative code shall remain
 *    under the copyright of the copyright holder(s) and/or original author(s)per
 *    the Attribution and Assignment Agreement that can be located at
 *    http://www.open-xchange.com/EN/developer/. The contributing author shall be
 *    given Attribution for the derivative code and a license granting use.
 *
 *     Copyright (C) 2004-2013 Open-Xchange, Inc.
 *     Mail: info@open-xchange.com
 *
 *
 *     This program is free software; you can redistribute it and/or modify it
 *     under the terms of the GNU General Public License, Version 2 as published
 *     by the Free Software Foundation.
 *
 *     This program is distributed in the hope that it will be useful, but
 *     WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 *     or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License
 *     for more details.
 *
 *     You should have received a copy of the GNU General Public License along
 *     with this program; if not, write to the Free Software Foundation, Inc., 59
 *     Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 */

package com.openexchange.packaging;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.regex.Matcher;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.Task;
import com.openexchange.Definitions;

/**
 * {@link ReadPackageName}
 *
 * @author <a href="mailto:marcus.klein@open-xchange.com">Marcus Klein</a>
 */
public final class ReadPackageName extends Task {

    private File changelog;
    private String property;

    public ReadPackageName() {
        super();
    }

    public void setChangelog(File changelog) {
        this.changelog = changelog;
    }

    public void setProperty(String property) {
        this.property = property;
    }

    @Override
    public void execute() throws BuildException {
        if (null == changelog) {
            throw new BuildException("changelog not defined");
        }
        if (null == property) {
            throw new BuildException("output property not defined");
        }
        if (!changelog.exists()) {
            throw new BuildException("changelog does not exist");
        }
        InputStream is = null;
        InputStreamReader isr = null;
        BufferedReader br = null;
        final String firstLine;
        try {
            is = new FileInputStream(changelog);
            isr = new InputStreamReader(is);
            br = new BufferedReader(isr);
            firstLine = br.readLine();
        } catch (IOException e) {
            throw new BuildException("Unable to read changelog file", e);
        } finally {
            try {
                if (null != br) {
                    br.close();
                }
            } catch (IOException e) {
                getProject().log("unable to close stream for changelog file", Project.MSG_ERR);
                StringWriter sw = new StringWriter();
                e.printStackTrace(new PrintWriter(sw));
                getProject().log(sw.toString(), Project.MSG_DEBUG);
            }
            try {
                if (null != isr) {
                    isr.close();
                }
            } catch (IOException e) {
                getProject().log("unable to close stream for changelog file", Project.MSG_ERR);
                StringWriter sw = new StringWriter();
                e.printStackTrace(new PrintWriter(sw));
                getProject().log(sw.toString(), Project.MSG_DEBUG);
            }
            try {
                if (null != is) {
                    is.close();
                }
            } catch (IOException e) {
                getProject().log("unable to close stream for changelog file", Project.MSG_ERR);
                StringWriter sw = new StringWriter();
                e.printStackTrace(new PrintWriter(sw));
                getProject().log(sw.toString(), Project.MSG_DEBUG);
            }
        }
        Matcher matcher = Definitions.DEBIAN_CHANGELOG_FIRSTLINE_PATTERN.matcher(firstLine);
        if (!matcher.matches()) {
            throw new BuildException("first line of changelog can not be parsed: \"" + firstLine + "\"");
        }
        final String packageName = matcher.group(1);
        getProject().log("setting property " + property + " to value " + packageName, Project.MSG_VERBOSE);
        getProject().setInheritedProperty(property, packageName);
    }
}
